/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpCommon;

import ibm.nways.analysis.dpCommon.DpNullResourceManagerException;
import ibm.nways.analysis.dpCommon.DpResourceInstance;
import ibm.nways.analysis.dpCommon.DpResourceManager;
import ibm.nways.analysis.dpCommon.PerformanceEvent;
import ibm.nways.analysis.dpCommon.PollingObjectInstance;
import ibm.nways.analysis.dpCommon.ResourceDefinition;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class ResourceInstance
implements Serializable {
    private String initialCommunityName;
    private String hostname;
    private ResourceDefinition definition;
    private transient DpResourceManager resource;
    private DpResourceInstance tableIndices;
    private long resourceInstanceKey;
    private Vector instances;
    private Vector pois;
    private int armCount;
    private boolean isArmed = false;

    public ResourceInstance(String string, ResourceDefinition resourceDefinition) {
        this.hostname = string;
        this.definition = resourceDefinition;
    }

    public ResourceInstance(String string, ResourceDefinition resourceDefinition, DpResourceManager dpResourceManager) {
        this.hostname = string;
        this.definition = resourceDefinition;
        this.resource = dpResourceManager;
    }

    public ResourceInstance(String string, ResourceDefinition resourceDefinition, DpResourceManager dpResourceManager, long l) {
        this.hostname = string;
        this.definition = resourceDefinition;
        this.resource = dpResourceManager;
        if (dpResourceManager != null) {
            this.tableIndices = dpResourceManager.dpGetResourceInstance();
        }
        this.resourceInstanceKey = l;
    }

    public ResourceInstance(String string, ResourceDefinition resourceDefinition, DpResourceManager dpResourceManager, long l, String string2) {
        this.hostname = string;
        this.definition = resourceDefinition;
        this.resource = dpResourceManager;
        if (dpResourceManager != null) {
            this.tableIndices = dpResourceManager.dpGetResourceInstance();
        }
        this.resourceInstanceKey = l;
        this.initialCommunityName = string2;
    }

    public ResourceInstance(String string, ResourceDefinition resourceDefinition, Vector vector) {
        this.hostname = string;
        this.definition = resourceDefinition;
        this.instances = vector;
    }

    public String getHostname() {
        return this.hostname;
    }

    public ResourceDefinition getDefinition() {
        return this.definition;
    }

    public Vector getInstances() {
        return this.instances;
    }

    public Vector getPOIs() {
        return this.pois;
    }

    public void setPOIs(Vector vector) {
        this.pois = vector;
    }

    public void setDpResourceManager(DpResourceManager dpResourceManager) {
        this.resource = dpResourceManager;
    }

    public PerformanceEvent incArmed(PerformanceEvent performanceEvent) {
        PerformanceEvent performanceEvent2 = null;
        ++this.armCount;
        if (!this.isArmed && this.armCount != 0) {
            this.isArmed = true;
            if (this.resource != null) {
                try {
                    this.resource.dpSetState(performanceEvent);
                }
                catch (DpNullResourceManagerException dpNullResourceManagerException) {}
            }
            performanceEvent2 = new PerformanceEvent(1, this.hostname, this.definition.getIdentifier(), System.currentTimeMillis());
        }
        return performanceEvent2;
    }

    public PerformanceEvent decArmed(PerformanceEvent performanceEvent) {
        PerformanceEvent performanceEvent2 = null;
        --this.armCount;
        if (this.isArmed && this.armCount == 0) {
            this.isArmed = false;
            if (this.resource != null) {
                try {
                    this.resource.dpSetState(performanceEvent);
                }
                catch (DpNullResourceManagerException dpNullResourceManagerException) {}
            }
            performanceEvent2 = new PerformanceEvent(2, this.hostname, this.definition.getIdentifier(), System.currentTimeMillis());
        }
        return performanceEvent2;
    }

    public void setManaged(boolean bl) {
        try {
            if (bl && this.resource != null) {
                this.resource.dpSetState(new PerformanceEvent(8, this.resource.dpGetHostname(), this.resource.dpGetResourceType(), null, 0L, 0L));
                return;
            }
            if (!bl && this.resource != null) {
                this.resource.dpSetState(new PerformanceEvent(16, this.resource.dpGetHostname(), this.resource.dpGetResourceType(), null, 0L, 0L));
                return;
            }
        }
        catch (DpNullResourceManagerException dpNullResourceManagerException) {}
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("hostname :");
        stringBuffer.append(this.hostname);
        if (this.definition != null) {
            stringBuffer.append("resource id: ");
            stringBuffer.append(this.definition.getIdentifier());
        }
        if (this.instances != null) {
            stringBuffer.append("instances :");
            stringBuffer.append(this.instances);
        }
        if (this.pois != null) {
            stringBuffer.append("Poi list: \n");
            Enumeration enumeration = this.pois.elements();
            while (enumeration.hasMoreElements()) {
                PollingObjectInstance pollingObjectInstance = (PollingObjectInstance)enumeration.nextElement();
                stringBuffer.append(String.valueOf(pollingObjectInstance.getIndex()) + "\n");
            }
        }
        if (this.isArmed) {
            stringBuffer.append("instance is armed");
        } else {
            stringBuffer.append("instance is unarmed");
        }
        return stringBuffer.toString();
    }

    public boolean getIsArmed() {
        return this.isArmed;
    }

    public void setState(PerformanceEvent performanceEvent) {
        if (this.resource != null) {
            try {
                this.resource.dpSetState(performanceEvent);
                return;
            }
            catch (DpNullResourceManagerException dpNullResourceManagerException) {
                return;
            }
        }
    }

    public String getCommunityName() {
        String string = null;
        if (this.resource != null) {
            string = this.resource.dpGetCommunityName();
        }
        string = this.initialCommunityName;
        return string;
    }

    public void setTableIndices(DpResourceInstance dpResourceInstance) {
        this.tableIndices = dpResourceInstance;
    }

    public DpResourceInstance getTableIndices() {
        return this.tableIndices;
    }

    public long getKey() {
        return this.resourceInstanceKey;
    }
}

